"use client"
import {Building, ClipboardCheck, Home, Settings} from "lucide-react";
import Link from "next/link";
import {usePathname} from "next/navigation";

export function Footer() {
    const pathname = usePathname();
    return (
        <nav className="sticky bottom-0 left-0 right-0 bg-white shadow-lg">
            <ul className="flex justify-around">
                {[
                    {href: '/dashboard', icon: Home, label: 'Accueil'},
                    {href: '/settings/properties', icon: Building, label: 'Propriétés'},
                    {href: '/inspections', icon: ClipboardCheck, label: 'Inspections'},
                    {href: '/settings', icon: Settings, label: 'Paramètres'},
                ].map((item) => (
                    <li key={item.href}>
                        <Link
                            href={item.href}
                            className={`flex flex-col items-center py-2 px-3 ${
                                pathname === item.href ? 'text-[#8B5CF6]' : 'text-gray-500'
                            }`}
                        >
                            <item.icon className="h-5 w-5"/>
                            <span className="text-xs mt-1">{item.label}</span>
                        </Link>
                    </li>
                ))}
            </ul>
        </nav>
    )
}