'use client'

import Link from 'next/link'
import Image from 'next/image'
import { Button } from "@/components/ui/button"

export function BlockPage() {
  return (
    <div className="min-h-screen bg-white p-4">
      {/* Status Bar */}
      <div className="flex justify-between items-center mb-8">
        <span className="text-black text-sm">9:41</span>
        <div className="flex items-center gap-1">
          <div className="w-4 h-4">
            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M12.01 21.49L23.64 7C23.19 6.66 18.71 3 12 3C5.28 3 0.81 6.66 0.36 7L12 21.49L12.01 21.49Z" fill="currentColor"/>
            </svg>
          </div>
          <div className="w-4 h-4">
            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M17 5.33C17 4.6 16.4 4 15.67 4H14V2H10V4H8.33C7.6 4 7 4.6 7 5.33V20.67C7 21.4 7.6 22 17 21.4 17 20.67V5.33Z" fill="currentColor"/>
            </svg>
          </div>
        </div>
      </div>

      {/* Logo and Brand */}
      <div className="flex items-center gap-3 mb-32">
        <div className="w-12 h-12 bg-[#8B5CF6] rounded-lg flex items-center justify-center">
          <div className="grid grid-cols-2 gap-1">
            <div className="w-2 h-2 bg-white rounded-sm"></div>
            <div className="w-2 h-2 bg-white rounded-sm"></div>
            <div className="w-2 h-2 bg-white rounded-sm"></div>
            <div className="w-2 h-2 bg-white rounded-sm"></div>
          </div>
        </div>
        <span className="text-2xl font-bold text-[#1F2937]">CasaOK</span>
      </div>

      {/* Main Content */}
      <div className="space-y-4 mb-32">
        <h1 className="text-4xl font-bold text-[#1F2937]">
          Commençons
        </h1>
        <p className="text-gray-600 text-lg">
          Gérer vos propriétés n'a jamais été aussi simple.
        </p>
      </div>

      {/* Action Buttons */}
      <div className="space-y-4">
        <Link href="/login" className="block">
          <Button 
            className="w-full h-14 text-lg bg-[#8B5CF6] hover:bg-[#7C3AED] text-white rounded-xl"
          >
            Connexion
          </Button>
        </Link>
        
        <Link href="/signup" className="block">
          <Button 
            variant="outline"
            className="w-full h-14 text-lg border-2 border-[#8B5CF6] text-[#8B5CF6] rounded-xl hover:bg-[#8B5CF6] hover:text-white"
          >
            Créer un compte
          </Button>
        </Link>
      </div>

      {/* Guest Link */}
      <div className="mt-8 text-center">
        <Link 
          href="/dashboard"
          className="text-[#8B5CF6] hover:underline inline-block py-2"
        >
          Continuer en tant qu'invité
        </Link>
      </div>
    </div>
  )
}